/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class MapRenderHelper {
    public static void renderTexturedModalRect(float x, float y, float width, float height, int textureX, int textureY, float textureW, float textureH, float fullTextureWidth, float fullTextureHeight) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float normalizedTextureX = (float)textureX / fullTextureWidth;
        float normalizedTextureY = (float)textureY / fullTextureHeight;
        float normalizedTextureX2 = ((float)textureX + textureW) / fullTextureWidth;
        float normalizedTextureY2 = ((float)textureY + textureH) / fullTextureHeight;
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a((double)normalizedTextureX, (double)normalizedTextureY2).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)normalizedTextureX2, (double)normalizedTextureY2).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a((double)normalizedTextureX2, (double)normalizedTextureY).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a((double)normalizedTextureX, (double)normalizedTextureY).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderDynamicHighlight(int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        int sideColor = MapRenderHelper.getColorInt(sideR, sideG, sideB, sideA);
        int centerColor = MapRenderHelper.getColorInt(centerR, centerG, centerB, centerA);
        Gui.func_73734_a((int)(leftX - 1 - flooredCameraX), (int)(topZ - 1 - flooredCameraZ), (int)(leftX - flooredCameraX), (int)(bottomZ + 1 - flooredCameraZ), (int)sideColor);
        Gui.func_73734_a((int)(leftX - flooredCameraX), (int)(topZ - 1 - flooredCameraZ), (int)(rightX - flooredCameraX), (int)(topZ - flooredCameraZ), (int)sideColor);
        Gui.func_73734_a((int)(rightX - flooredCameraX), (int)(topZ - 1 - flooredCameraZ), (int)(rightX + 1 - flooredCameraX), (int)(bottomZ + 1 - flooredCameraZ), (int)sideColor);
        Gui.func_73734_a((int)(leftX - flooredCameraX), (int)(bottomZ - flooredCameraZ), (int)(rightX - flooredCameraX), (int)(bottomZ + 1 - flooredCameraZ), (int)sideColor);
        Gui.func_73734_a((int)(leftX - flooredCameraX), (int)(topZ - flooredCameraZ), (int)(rightX - flooredCameraX), (int)(bottomZ - flooredCameraZ), (int)centerColor);
    }

    public static int getColorInt(float r, float g, float b, float a) {
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        int ai = (int)(a * 255.0f);
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }
}

